<?php
/*
Plugin Name: My Memo Plugin
Description: 記事にメモ機能を追加するプラグイン
Version: 1.0
Author: Yuji Ito
*/

//直接アクセス禁止
if (!defined('ABSPATH')) exit;

// メモのカラムを追加
function my_memo_columns_head($defaults) {
    $defaults['my_memo'] = 'メモ';
    return $defaults;
}
add_filter('manage_posts_columns', 'my_memo_columns_head');

// カラムの内容を表示
function my_memo_columns_content($column_name, $post_ID) {
    if ($column_name === 'my_memo') {
        $memo = get_post_meta($post_ID, 'my_memo', true);
        $memo_lines = substr_count($memo, "\n") + 1; // 改行の数を数えて行数を計算
        $max_lines = 6; // 最大行数を設定
        if ($memo_lines > $max_lines) {
            $memo = wpautop($memo); // 改行を自動的に <p> タグに変換
            echo '<div style="max-height: ' . ($max_lines * 20) . 'px; overflow: auto;">' . $memo . '</div>';
        } else {
            echo esc_html($memo);
        }
    }
}
add_action('manage_posts_custom_column', 'my_memo_columns_content', 10, 2);

// メモのメタボックスを追加
function my_memo_meta_box() {
    add_meta_box(
        'my-memo-meta-box',
        'メモ',
        'my_memo_meta_box_content',
        array('post', 'page'),
        'side',
        'default'
    );
}
add_action('add_meta_boxes', 'my_memo_meta_box');

// メモのメタボックスの内容を表示
function my_memo_meta_box_content($post) {
    $memo = get_post_meta($post->ID, 'my_memo', true);
    wp_nonce_field('my_memo_nonce', 'my_memo_nonce');
    ?>
    <textarea name="my_memo" style="width: 100%; " rows="10"><?php echo esc_textarea($memo); ?></textarea>
    <?php
}

// メモのメタボックスの値を保存
function my_memo_save_post($post_id) {
    if (!isset($_POST['my_memo_nonce']) || !wp_verify_nonce($_POST['my_memo_nonce'], 'my_memo_nonce')) {
        return;
    }

    if (defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) {
        return;
    }

    if (isset($_POST['my_memo'])) {
        update_post_meta($post_id, 'my_memo', $_POST['my_memo']);
    }
}
add_action('save_post', 'my_memo_save_post');
